<?php
// ----- PDO Connection -----
$host = 'localhost';
$dbname = 'demoptma_solving_publishing';
$username = 'demoptma_solving_publishing';
$password = 'sDHsgS%0P*v]';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8mb4", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    $pdo->setAttribute(PDO::ATTR_DEFAULT_FETCH_MODE, PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    die("Database connection failed: " . $e->getMessage());
}

// ----- Handle Form Submission -----
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $merchant = $_POST['merchant'];
    $agent = $_POST['agent_name'];
    $clientName = $_POST['client_name'];
    $clientEmail = $_POST['client_email'];
    $clientPhone = $_POST['client_phone'];
    $package = $_POST['package'];
    $amount = floatval($_POST['amount']);

    $stmt = $pdo->prepare("INSERT INTO invoices 
        (merchant, agent_name, client_name, client_email, client_phone, package, amount) 
        VALUES (?, ?, ?, ?, ?, ?, ?)");
    $stmt->execute([$merchant, $agent, $clientName, $clientEmail, $clientPhone, $package, $amount]);

    $invoiceId = $pdo->lastInsertId();

    header("Location: invoice.php"); // redirect to invoice list
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <link rel="shortcut icon" href="../assets/img/favicon.png" type="image/x-icon">
    <title>Create Invoice | Solving Publishing</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.1/css/all.min.css" integrity="sha512-2SwdPD6INVrV/lHTZbO2nodKhrnDdJK9/kg2XD1r9uGqPo1cUbujc+IYdlYdEErWNu69gVcYgdxlmVmzTWnetw==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <style>
        body {
            display: flex;
            min-height: 100vh;
            background: #f4f6f9;
            font-family: "Poppins", sans-serif;
        }
        .sidebar {
            width: 250px;
            background: #043773;
            color: #ecf0f1;
            padding-top: 20px;
            height: 100vh;
            position: fixed;
        }
        .sidebar h2 {
            text-align: center;
            margin-bottom: 30px;
        }
        .sidebar a {
            display: block;
            color: #ecf0f1;
            padding: 20px 20px;
            text-decoration: none;
            font-family: "Poppins", sans-serif;
            border-bottom: 0.7px solid #ffffff47;
        }
        .sidebar a:hover {
            background: #34495e;
        }
        .content {
            flex-grow: 1;
            margin-left: 250px;
            padding: 30px;
        }
        table {
            background: #fff;
        }
        .json-preview {
            max-width: 300px;
            white-space: pre-wrap;
            word-break: break-all;
            font-size: 13px;
            background: #f8f9fa;
            padding: 8px;
            border-radius: 4px;
        }
        
        .content {
            font-family: "Inter", sans-serif;
        }
        
        .content h1 {
            font-family: "Poppins", sans-serif;
            color: #043773;
        }
        
        /*.create-invoice {*/
        /*    text-align: end;*/
        /*}*/
        
        .create-invoice a {
            background-color: #043773;
            color: white;
            padding: 0.5rem 0.7rem;
            font-family: "Inter", sans-serif;
        }
        
        .table-dark {
            --bs-table-bg: #043773 !important;
        }
        
        table th, table td {
            font-size: 0.9rem !important;
            font-family: "Inter", sans-serif;
            padding: 1rem 2rem !important;
        }
        
        .view-inv {
            background-color: #043773;
            padding: 0.5rem 0.4rem;
            border: none;
        }
        .sub-inv {
            background-color: #043773;
        }
        .sidebar-logo {
            filter: brightness(0.5) invert(1);
        }
    </style>
</head>
<body>

<div class="sidebar">
    <div class="sidebar-logo" style="display:flex;justify-content:center;padding-bottom:3rem;">
        <img src="../assets/img/logo-white.png" width="70%">
    </div>
    
    
    
    <a href="invoice.php" class="active">Invoice</a>
</div>

<div class="content">
    <div class="content-header" style="display:flex;justify-content:space-between;align-items:center; padding-bottom: 1rem;">
    </div>
    <div class="container py-5">
  <div class="row justify-content-center">
    <div class="col-md-10">
      <div class="card shadow-lg border-0 rounded-4">
        <div class="card-body p-4">
          <h4 class="text-center mb-4 fw-bold" style='font-family: "Poppins", sans-serif;'>Create Invoice</h4>

          <form method="post">
            <div class="mb-3">
              <label class="form-label">Merchant</label>
              <select name="merchant" class="form-select" required>
                <option value="">Select Merchant</option>
                <option value="authorize">Nexio (Authorize)</option>
                <option value="payarc">Payarc (Authorize)</option>
              </select>
            </div>

            <div class="mb-3">
              <label class="form-label">Agent Name</label>
              <input type="text" name="agent_name" class="form-control" placeholder="Enter agent name" required>
            </div>

            <div class="mb-3">
              <label class="form-label">Client Name</label>
              <input type="text" name="client_name" class="form-control" placeholder="Enter client name" required>
            </div>

            <div class="mb-3">
              <label class="form-label">Email</label>
              <input type="email" name="client_email" class="form-control" placeholder="Enter email">
            </div>

            <div class="mb-3">
              <label class="form-label">Phone</label>
              <input type="text" name="client_phone" class="form-control" placeholder="Enter phone number">
            </div>

            <div class="mb-3">
              <label class="form-label">Package</label>
              <input type="text" name="package" class="form-control" placeholder="Enter package name" required>
            </div>

            <div class="mb-4">
              <label class="form-label">Amount</label>
              <input type="number" name="amount" class="form-control" step="0.01" placeholder="Enter amount" required>
            </div>

            <div class="d-grid">
              <button type="submit" class="sub-inv btn btn-success btn-lg rounded-pill">
                <i class="bi bi-receipt-cutoff me-2"></i> Create Invoice
              </button>
            </div>
          </form>
        </div>
      </div>
    </div>
  </div>
</div>
    
</div>
<script src="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.1/js/all.min.js" integrity="sha512-6BTOlkauINO65nLhXhthZMtepgJSghyimIalb+crKRPhvhmsCdnIuGcVbR5/aQY2A+260iC1OPy1oCdB6pSSwQ==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
</body>
</html>

